#calculate the mean and variance for each treatment
#calculate the mean change for each treatment
#calculate net intervention effect
#calculate hedge's g for the net effect (net intervention effect / pooled sd)
#calculate standard error of Hedge's g (sqrt(1/n))

rm(list=ls())
#hedge's g stats
library(tidyverse) 
library(ggplot2)
library(patchwork)
library(effsize)
library(metafor)
library(boot)

#S1S3####
setwd("D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/Essex data repository")
load("s1s3ecologicalmetrics.Rdata")
df1 <- s1s3ecologicalmetrics

## Functions ready----
safe_sd <- function(x) {
  if (sum(!is.na(x)) <= 1) { # Correctly checks if there's only 1 or 0 valid observations
    return(0)
  } else {
    return(sd(x, na.rm = TRUE))
  }
}

#pooled standard deviation to calculate hedge's g (used to be divided by delta mean impact and delta mean control)
sd_hedge <- function(n1,n2,n3,n4,sd1,sd2,sd3,sd4){ #raw sample size at the impact/control before and after the intervention
  n = n1+n2+n3+n4
  x1 = (n1-1)*sd1^2
  x2 = (n2-1)*sd2^2
  x3 = (n3-1)*sd3^2
  x4 = (n4-1)*sd4^2
  sd_hedge = sqrt((x1+x2+x3+x4)/(n-4))
  return(sd_hedge)
}

#hedge = (delta_meanimpact-delta_meancontrol)/pooled standard deviation(sd_hedge)
#hedge_corrected = hedge*(1-3/(4*(N-2)-1))

se_hedge <- function(n1,n2,n3,n4,hedge){ #n1,n3 prepost impact;n2,n4 prepost control
  n=n1+n2+n3+n4
  n_impact = n1+n3
  n_control = n2+n4
  #small sample correction incorporated below (J = 1 - 3/(4(N-2)-1))
  J = 1 - 3 / (4*(n-2)-1)
  var_hedge = (n / (n_impact * n_control)) + (hedge^2 / (2 * n))
  return(sqrt(var_hedge) * J)
}

#this bootstrap function assumes t-distribution
bootstrap_hedge_CI <- function(hedge, se_hedge, n1, n2, n3, n4, R = 1000, conf.level = 0.95) {
  # Calculate degrees of freedom for t-distribution
  n = n1 + n2 + n3 + n4
  df = n - 4
  # Generate bootstrap samples using t-distribution
  boot_samples <- rt(R, df = df) * se_hedge + hedge
  # Compute percentile CI
  lower_CI <- quantile(boot_samples, (1 - conf.level) / 2, type = 6) # bias-corrected percentile bootstrap
  upper_CI <- quantile(boot_samples, (1 + conf.level) / 2, type = 6)
  # Return results
  return(CIs = c(lower_CI, upper_CI))
}

## Calculate the mean and variance for each treatment----
#mean and variance of the impact before the intervention
meanimpact_pre <- df1 %>%
  filter(Treatment == "pre Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdimpact_pre <- df1 %>%
  filter(Treatment == "pre Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )

#mean and variance of the impact after the intervention
meanimpact_post <- df1 %>%
  filter(Treatment == "post Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )


sdimpact_post <- df1 %>%
  filter(Treatment == "post Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#mean and variance of the control before the intervention
meancontrol_pre <- df1 %>%
  filter(Treatment == "pre Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdcontrol_pre <- df1 %>%
  filter(Treatment == "pre Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#mean and variance of the control after the intervention
meancontrol_post <- df1 %>%
  filter(Treatment == "post Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdcontrol_post <- df1 %>%
  filter(Treatment == "post Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#Calculate the raw sample size for each treatment
samplesize <- df1 %>%
  group_by(TargetMMS,Treatment) %>%
  summarise(n_sample = n())


## Calculate the mean change for each treatment----
mmslist <- meancontrol_post$TargetMMS
meanimpact_post$TargetMMS <- NULL
meanimpact_pre$TargetMMS <- NULL
meancontrol_post$TargetMMS <- NULL
meancontrol_pre$TargetMMS <- NULL
delta_meanimpact <- meanimpact_post - meanimpact_pre
delta_meancontrol <- meancontrol_post - meancontrol_pre
delta_meanimpact$TargetMMS <- mmslist
delta_meancontrol$TargetMMS <- mmslist


## Calculate the net intervention effect----
delta_meanimpact$TargetMMS <- NULL
delta_meancontrol$TargetMMS <- NULL
neteffect <- delta_meanimpact - delta_meancontrol
neteffect$TargetMMS <- mmslist


## Calculate Hedge's g for the net intervention effect for each O&G ifnrastructure----
#mms=29/07-10Y

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_290710Y <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                  ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                  ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                  ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_290710Y) <- c("lower_CI","upper_CI")
hedge_290710Y$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                           hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                           hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
hedge_290710Y$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                        se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                        se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_290710Y$Metrics <- c("abun","bodymass","spprichness","evenness",
                           "pob","poi","pot","mtl","generalitySD",
                           "vulnerabilitySD","linkrichness",
                           "linkagedensity","connectance")
hedge_290710Y$Metrics <- factor(hedge_290710Y$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                 "pob","poi","pot","mtl","generalitySD",
                                                                 "vulnerabilitySD","linkrichness",
                                                                 "linkagedensity","connectance"))
hedge_290710Y$MMS <- "29/07-10Y"





#mms=44/12- 1

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_44121 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_44121) <- c("lower_CI","upper_CI")
hedge_44121$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
hedge_44121$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_44121$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_44121$Metrics <- factor(hedge_44121$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_44121$MMS <- "44/12- 1"




#mms = "North West Hutton"

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_NWH <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                              ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                              ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                              ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_NWH) <- c("lower_CI","upper_CI")
hedge_NWH$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                       hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                       hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
hedge_NWH$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                    se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                    se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_NWH$Metrics <- c("abun","bodymass","spprichness","evenness",
                       "pob","poi","pot","mtl","generalitySD",
                       "vulnerabilitySD","linkrichness",
                       "linkagedensity","connectance")
hedge_NWH$Metrics <- factor(hedge_NWH$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                         "pob","poi","pot","mtl","generalitySD",
                                                         "vulnerabilitySD","linkrichness",
                                                         "linkagedensity","connectance"))
hedge_NWH$MMS <- "North West Hutton"


# #mms=Moray Firth 11/25
# #effect size - abundance
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_abun
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_abun
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_abun
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_abun
# sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_abun <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_abun / sd_hedge_abun
# hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
# ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
# #effect size - body mass
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_bodymass
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_bodymass
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_bodymass
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_bodymass
# sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_bodymass <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_bodymass / sd_hedge_bodymass
# hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
# ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
# #effect size - species richness
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_richness
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_richness
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_richness
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_richness
# sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_richness <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_richness / sd_hedge_richness
# hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
# ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
# #effect size - Pielou's evenness
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_evenness
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_evenness
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_evenness
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_evenness
# sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_evenness <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_evenness / sd_hedge_evenness
# hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
# ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
# #effect size - proportionofbasal
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_pob
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_pob
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_pob
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_pob
# sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_pob <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_pob / sd_hedge_pob
# hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
# ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
# #effect size - proportionofintermediate
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_poi
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_poi
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_poi
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_poi
# sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_poi <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_poi / sd_hedge_poi
# hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
# ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
# #effect size - proportionoftop
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_pot
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_pot
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_pot
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_pot
# sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_pot <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_pot / sd_hedge_pot
# hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
# ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
# #effect size - meantrophiclevel
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_mtl
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_mtl
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_mtl
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_mtl
# sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_mtl <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_mtl / sd_hedge_mtl
# hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
# ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
# #effect size - generalitySD
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_generalitySD
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_generalitySD
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_generalitySD
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_generalitySD
# sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_generalitySD <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_generalitySD / sd_hedge_generalitySD
# hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
# ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
# #effect size - vulnerabilitySD
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_vulnerabilitySD
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_vulnerabilitySD
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_vulnerabilitySD
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_vulnerabilitySD
# sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
# hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
# ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
# #effect size - linkrichness
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_linkrichness
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_linkrichness
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_linkrichness
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_linkrichness
# sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_linkrichness <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_linkrichness / sd_hedge_linkrichness
# hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
# ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
# #effect size - linkagedensity
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_linkagedensity
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_linkagedensity
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_linkagedensity
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_linkagedensity
# sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_linkagedensity / sd_hedge_linkagedensity
# hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
# ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
# #effect size - connectance
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_connectance
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_connectance
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_connectance
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_connectance
# sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_connectance <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_connectance / sd_hedge_connectance
# hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
# ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)
# 
# hedge_MorayFirth1125 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
#                                          ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
#                                          ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
#                                          ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
# colnames(hedge_MorayFirth1125) <- c("lower_CI","upper_CI")
# hedge_MorayFirth1125$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
#                                   hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
#                                   hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
# hedge_MorayFirth1125$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
#                                se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
#                                se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
# hedge_MorayFirth1125$Metrics <- c("abun","bodymass","spprichness","evenness",
#                                   "pob","poi","pot","mtl","generalitySD",
#                                   "vulnerabilitySD","linkrichness",
#                                   "linkagedensity","connectance")
# hedge_MorayFirth1125$Metrics <- factor(hedge_MorayFirth1125$Metrics,levels = c("abun","bodymass","spprichness","evenness",
#                                                                                "pob","poi","pot","mtl","generalitySD",
#                                                                                "vulnerabilitySD","linkrichness",
#                                                                                "linkagedensity","connectance"))
# hedge_MorayFirth1125$MMS <- "Moray Firth 11/25"


## Combine all hedge's g across O&G infrastructure ----
#hedge_all <- rbind(hedge_290710Y,hedge_44121,hedge_NWH,hedge_MorayFirth1125)
hedge_all <- rbind(hedge_290710Y,hedge_44121,hedge_NWH)

hedge_all$Metrics <- gsub("abun","abundance",hedge_all$Metrics)
hedge_all$Metrics <- gsub("bodymass","body mass",hedge_all$Metrics)
hedge_all$Metrics <- gsub("spprichness","richness",hedge_all$Metrics)
hedge_all$Metrics <- gsub("pob","proportion of basal",hedge_all$Metrics)
hedge_all$Metrics <- gsub("poi","proportion of intermediate",hedge_all$Metrics)
hedge_all$Metrics <- gsub("pot","proportion of top",hedge_all$Metrics)
hedge_all$Metrics <- gsub("mtl","mean trophic level",hedge_all$Metrics)
hedge_all$Metrics <- gsub("linkrichness","link richness",hedge_all$Metrics)
hedge_all$Metrics <- gsub("linkagedensity","linkage density",hedge_all$Metrics)

hedge_all$Metrics <- factor(hedge_all$Metrics,
                            levels=c("connectance","linkage density",
                                     "link richness","vulnerabilitySD",
                                     "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                     "proportion of basal","evenness","richness",
                                     "body mass","abundance"))
unique(hedge_all$MMS)


library(orchaRd)
library(flextable)

#sievegear <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton","Moray Firth 11/25"),
#                        SieveGear=c("H_Day Grab","1_Day Grab","H_Day Grab","Both_Unknown"))
#hedge_all2 <- merge(hedge_all,sievegear,by="MMS",all.x=T)
mod0 <- rma.mv(hedge_g,
               Vars,
               #without intercept (no reference level - focus on estimate and CI of each metric)
               #using~Metrics-1,p value indicate whether estimate is significant different from 0
               #if using ~Metric, p value indicate the difference between each level of metric and reference level
               mods = ~Metrics - 1, 
               test = "t",
               #random = list(~ 1|MMS,~1|SieveGear),
               random = ~1|MMS,
               data=hedge_all)
summary.rma(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                         "proportion of basal","evenness","richness",
                                         "body mass","abundance")),
                       data=hedge_all)

(p <- orchard_plot(resmod0,xlab="Hedge's g",
                   group = "MMS", mod = "Metrics",angle = 0,trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    #can manually set the color using scale_fill_manual
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values = c("grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    scale_color_manual(values = c("grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

###if orchard plot wants to split into well and plat separately
# unique(hedge_all2$MMS)
# MMStype <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton","16/21c- 32Y","Moray Firth 11/25"),
#                       Type=c("Well","Well","Platform","Well","Well"))
MMStype <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton"),
                     Type=c("Well","Well","Platform"))
hedge_all3 <- hedge_all %>%
  left_join(MMStype,by=c("MMS"))

#hedge_all3 <- merge(hedge_all2,MMStype,by="MMS",all.x=T)

hedge_all3_well <- hedge_all3[hedge_all3$Type=="Well",]
hedge_all3_plat <- hedge_all3[hedge_all3$Type=="Platform",]

#try wells
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test = "t",
               random = ~ 1|MMS,
               data=hedge_all3_well)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level",
                                         "proportion of top","proportion of intermediate",
                                         "proportion of basal","evenness","richness",
                                         "body mass","abundance")),
                       data=hedge_all3_well)
resmod0$mod_table
(p1 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values = c("grey","grey","grey","grey","grey","black","grey","grey","grey","grey","grey","grey","grey"))+
    scale_color_manual(values = c("grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

###s1:Extract model estimates####

s1_ecologicalmetric <- data.frame(resmod0$mod_table)
s1_ecologicalmetric$pval <- mod0$pval #order of metrics is NOT opposite to pval
s1_ecologicalmetric$scenario <- c("scenario 1")


#well.diversity
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test="t",
               random = list(~ 1|MMS),
               data=hedge_all3_well)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("evenness","richness",
                                         "body mass","abundance")),
                       subset = T,
                       data=hedge_all3_well)
resmod0$mod_table
(p1.1 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","grey","grey"))+
    scale_color_manual(values=c("grey","grey","grey","grey"))+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p1.1,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s1_Diversity.png",width = 4,height=4,bg="white",dpi=600)

#well.foodweb
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test="t",
               random = list(~ 1|MMS),
               data=hedge_all3_well)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level",
                                         "proportion of top","proportion of intermediate",
                                         "proportion of basal")),
                       subset = T,
                       data=hedge_all3_well)
resmod0$mod_table

(p1.2 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","grey","grey","grey","black","grey","grey","grey"))+
    scale_color_manual(values=c("grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p1.2,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s1_FoodWeb.png",width = 4,height=4,bg="white",dpi=600)

(p1.3 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","grey","grey","grey","black","grey","grey","grey"))+
    scale_color_manual(values=c("grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p1.3,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s1_FoodWeb2.png",width = 4,height=4,bg="white",dpi=600)

#try platform
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               #test="t",
               #random = list(~ 1|MMS,~1|SieveGear),
               data=hedge_all3_plat)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                         "proportion of basal","evenness","richness",
                                         "body mass","abundance")),
                       data=hedge_all3_plat)
resmod0$mod_table
(p2 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("black","white","white","white","black","white","grey","white","black","white","white","grey","white"))+
    scale_color_manual(values=c("grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey","grey"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

###s3:Extract model estimates####
s3_ecologicalmetric <- data.frame(resmod0$mod_table)
s3_ecologicalmetric$pval <- mod0$pval #order of metrics is NOT opposite to pval
s3_ecologicalmetric$scenario <- c("scenario 3")

###s1s3:Combine model estimates####
s1s3_ecologicalmetric <- rbind(s1_ecologicalmetric,s3_ecologicalmetric)

#platform.diversity
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               #test="t",
               #random = ~1|MMS,
               #  random = list(~ 1|MMS,~1|SieveGear),
               data=hedge_all3_plat)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("evenness","richness",
                                         "body mass","abundance")),
                       subset=T,
                       data=hedge_all3_plat)
resmod0$mod_table
(p2.1 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("white","white","gray","white"))+
    scale_color_manual(values=c("gray","gray","gray","gray"))+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p2.1,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s3_Diversity.png",width = 4,height=4,bg="white",dpi=600)

#platform.foodweb
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               #test="t",
               #  random = list(~ 1|MMS,~1|SieveGear),
               data=hedge_all3_plat)
summary(mod0)
resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                         "proportion of basal")),
                       subset=T,
                       data=hedge_all3_plat)
resmod0$mod_table
(p2.2 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("black","white","white","white","black","white","gray","white","black"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p2.2,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s3_FoodWeb.png",width = 4,height=4,bg="white",dpi=600)

(p2.3 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("black","white","white","white","black","white","gray","white","black"))+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))
ggsave(p2.3,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s3_FoodWeb2.png",width = 4,height=4,bg="white",dpi=600)


#S2####
##Data loading####
setwd("D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/Essex data repository")
load("s2ecologicalmetrics.Rdata")
df1 <- s2ecologicalmetrics

## Calculate the mean and variance for each treatment----
#mean and variance of the impact before the intervention
meanimpact_pre <- df1 %>%
  filter(Treatment == "Early Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdimpact_pre <- df1 %>%
  filter(Treatment == "Early Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )

#mean and variance of the impact after the intervention
meanimpact_post <- df1 %>%
  filter(Treatment == "Later Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )


sdimpact_post <- df1 %>%
  filter(Treatment == "Later Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#mean and variance of the control before the intervention
meancontrol_pre <- df1 %>%
  filter(Treatment == "Early Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdcontrol_pre <- df1 %>%
  filter(Treatment == "Early Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#mean and variance of the control after the intervention
meancontrol_post <- df1 %>%
  filter(Treatment == "Later Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_abun = mean(abundance,na.rm=T),
    mean_bodymass = mean(bodymass,na.rm=T),
    mean_richness = mean(speciesrichness,na.rm=T),
    mean_evenness = mean(evenness,na.rm=T),
    mean_pob = mean(proportionofbasal,na.rm=T),
    mean_poi = mean(proportionofintermediate,na.rm=T),
    mean_pot = mean(proportionoftop,na.rm=T),
    mean_mtl = mean(meantrophiclevel,na.rm=T),
    mean_generalitySD = mean(generalitySD,na.rm=T),
    mean_vulnerabilitySD = mean(vulnerabilitySD,na.rm=T),
    mean_linkrichness = mean(linkrichness,na.rm=T),
    mean_linkagedensity = mean(linkagedensity,na.rm=T),
    mean_connectance = mean(connectance,na.rm=T)
  )

sdcontrol_post <- df1 %>%
  filter(Treatment == "Later Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_abun = safe_sd(abundance),
    sd_bodymass = safe_sd(bodymass),
    sd_richness = safe_sd(speciesrichness),
    sd_evenness = safe_sd(evenness),
    sd_pob = safe_sd(proportionofbasal),
    sd_poi = safe_sd(proportionofintermediate),
    sd_pot = safe_sd(proportionoftop),
    sd_mtl = safe_sd(meantrophiclevel),
    sd_generalitySD = safe_sd(generalitySD),
    sd_vulnerabilitySD = safe_sd(vulnerabilitySD),
    sd_linkrichness = safe_sd(linkrichness),
    sd_linkagedensity = safe_sd(linkagedensity),
    sd_connectance = safe_sd(connectance)
  )


#Calculate the raw sample size for each treatment
samplesize <- df1 %>%
  group_by(TargetMMS,Treatment) %>%
  summarise(n_sample = n())


## Calculate the mean change for each treatment----
mmslist <- meancontrol_post$TargetMMS
meanimpact_post$TargetMMS <- NULL
meanimpact_pre$TargetMMS <- NULL
meancontrol_post$TargetMMS <- NULL
meancontrol_pre$TargetMMS <- NULL
delta_meanimpact <- meanimpact_post - meanimpact_pre
delta_meancontrol <- meancontrol_post - meancontrol_pre
delta_meanimpact$TargetMMS <- mmslist
delta_meancontrol$TargetMMS <- mmslist


## Calculate the net intervention effect----
delta_meanimpact$TargetMMS <- NULL
delta_meancontrol$TargetMMS <- NULL
neteffect <- delta_meanimpact - delta_meancontrol
neteffect$TargetMMS <- mmslist

## Calculate Hedge's g for the net intervention effect for each O&G ifnrastructure----

#mms=13/22a- 11

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_1322a11 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                  ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                  ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                  ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_1322a11) <- c("lower_CI","upper_CI")
hedge_1322a11$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                           hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                           hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_1322a11$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                        se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                        se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_1322a11$Metrics <- c("abun","bodymass","spprichness","evenness",
                           "pob","poi","pot","mtl","generalitySD",
                           "vulnerabilitySD","linkrichness",
                           "linkagedensity","connectance")
hedge_1322a11$Metrics <- factor(hedge_1322a11$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                 "pob","poi","pot","mtl","generalitySD",
                                                                 "vulnerabilitySD","linkrichness",
                                                                 "linkagedensity","connectance"))
hedge_1322a11$MMS <- "13/22a- 11"


#mms = 13/24b- 3

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_1324b3 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                 ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                 ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                 ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_1324b3) <- c("lower_CI","upper_CI")
hedge_1324b3$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                          hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                          hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_1324b3$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                       se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                       se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_1324b3$Metrics <- c("abun","bodymass","spprichness","evenness",
                          "pob","poi","pot","mtl","generalitySD",
                          "vulnerabilitySD","linkrichness",
                          "linkagedensity","connectance")
hedge_1324b3$Metrics <- factor(hedge_1324b3$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                               "pob","poi","pot","mtl","generalitySD",
                                                               "vulnerabilitySD","linkrichness",
                                                               "linkagedensity","connectance"))
hedge_1324b3$MMS <- "13/24b- 3"


#mms = 15/20b- 12

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_1520b12 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                  ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                  ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                  ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_1520b12) <- c("lower_CI","upper_CI")
hedge_1520b12$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                           hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                           hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_1520b12$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                        se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                        se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_1520b12$Metrics <- c("abun","bodymass","spprichness","evenness",
                           "pob","poi","pot","mtl","generalitySD",
                           "vulnerabilitySD","linkrichness",
                           "linkagedensity","connectance")
hedge_1520b12$Metrics <- factor(hedge_1520b12$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                 "pob","poi","pot","mtl","generalitySD",
                                                                 "vulnerabilitySD","linkrichness",
                                                                 "linkagedensity","connectance"))
hedge_1520b12$MMS <- "15/20b- 12"


#mms = 15/23d- 13

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_1523d13 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                  ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                  ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                  ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_1523d13) <- c("lower_CI","upper_CI")
hedge_1523d13$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                           hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                           hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_1523d13$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                        se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                        se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_1523d13$Metrics <- c("abun","bodymass","spprichness","evenness",
                           "pob","poi","pot","mtl","generalitySD",
                           "vulnerabilitySD","linkrichness",
                           "linkagedensity","connectance")
hedge_1523d13$Metrics <- factor(hedge_1523d13$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                 "pob","poi","pot","mtl","generalitySD",
                                                                 "vulnerabilitySD","linkrichness",
                                                                 "linkagedensity","connectance"))
hedge_1523d13$MMS <- "15/23d- 13"


#mms = 16/03d- 14

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_1603d14 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                  ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                  ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                  ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_1603d14) <- c("lower_CI","upper_CI")
hedge_1603d14$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                           hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                           hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_1603d14$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                        se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                        se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_1603d14$Metrics <- c("abun","bodymass","spprichness","evenness",
                           "pob","poi","pot","mtl","generalitySD",
                           "vulnerabilitySD","linkrichness",
                           "linkagedensity","connectance")
hedge_1603d14$Metrics <- factor(hedge_1603d14$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                 "pob","poi","pot","mtl","generalitySD",
                                                                 "vulnerabilitySD","linkrichness",
                                                                 "linkagedensity","connectance"))
hedge_1603d14$MMS <- "16/03d- 14"


#mms = 	16/22- 6

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_16226 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_16226) <- c("lower_CI","upper_CI")
hedge_16226$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_16226$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_16226$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_16226$Metrics <- factor(hedge_16226$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_16226$MMS <- "16/22- 6"


#mms = 211/12a- 18

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_21112a18 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                   ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                   ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                   ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_21112a18) <- c("lower_CI","upper_CI")
hedge_21112a18$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                            hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                            hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_21112a18$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                         se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                         se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_21112a18$Metrics <- c("abun","bodymass","spprichness","evenness",
                            "pob","poi","pot","mtl","generalitySD",
                            "vulnerabilitySD","linkrichness",
                            "linkagedensity","connectance")
hedge_21112a18$Metrics <- factor(hedge_21112a18$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                                   "pob","poi","pot","mtl","generalitySD",
                                                                   "vulnerabilitySD","linkrichness",
                                                                   "linkagedensity","connectance"))
hedge_21112a18$MMS <- "211/12a- 18"


#mms = 22/29- 6

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_22296 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_22296) <- c("lower_CI","upper_CI")
hedge_22296$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_22296$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_22296$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_22296$Metrics <- factor(hedge_22296$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_22296$MMS <- "22/29- 6"


#mms = 29/10- 4

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_29104 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_29104) <- c("lower_CI","upper_CI")
hedge_29104$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_29104$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_29104$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_29104$Metrics <- factor(hedge_29104$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_29104$MMS <- "29/10- 4"


#mms = 	29/10- 5A

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_29105A <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                 ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                 ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                 ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_29105A) <- c("lower_CI","upper_CI")
hedge_29105A$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                          hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                          hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_29105A$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                       se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                       se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_29105A$Metrics <- c("abun","bodymass","spprichness","evenness",
                          "pob","poi","pot","mtl","generalitySD",
                          "vulnerabilitySD","linkrichness",
                          "linkagedensity","connectance")
hedge_29105A$Metrics <- factor(hedge_29105A$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                               "pob","poi","pot","mtl","generalitySD",
                                                               "vulnerabilitySD","linkrichness",
                                                               "linkagedensity","connectance"))
hedge_29105A$MMS <- "29/10- 5A"


#mms = 29/12- 2

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_29122 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_29122) <- c("lower_CI","upper_CI")
hedge_29122$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_29122$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_29122$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_29122$Metrics <- factor(hedge_29122$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_29122$MMS <- "29/12- 2"


#mms = 30/13- 5

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_30135 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_30135) <- c("lower_CI","upper_CI")
hedge_30135$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                         hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                         hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_30135$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                      se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                      se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_30135$Metrics <- c("abun","bodymass","spprichness","evenness",
                         "pob","poi","pot","mtl","generalitySD",
                         "vulnerabilitySD","linkrichness",
                         "linkagedensity","connectance")
hedge_30135$Metrics <- factor(hedge_30135$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                             "pob","poi","pot","mtl","generalitySD",
                                                             "vulnerabilitySD","linkrichness",
                                                             "linkagedensity","connectance"))
hedge_30135$MMS <- "30/13- 5"


#mms = 30/29a- 3

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_3029a3 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                 ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                 ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                 ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_3029a3) <- c("lower_CI","upper_CI")
hedge_3029a3$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                          hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                          hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_3029a3$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                       se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                       se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_3029a3$Metrics <- c("abun","bodymass","spprichness","evenness",
                          "pob","poi","pot","mtl","generalitySD",
                          "vulnerabilitySD","linkrichness",
                          "linkagedensity","connectance")
hedge_3029a3$Metrics <- factor(hedge_3029a3$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                               "pob","poi","pot","mtl","generalitySD",
                                                               "vulnerabilitySD","linkrichness",
                                                               "linkagedensity","connectance"))
hedge_3029a3$MMS <- "30/29a- 3"


#mms = 9/28a- 11

#effect size - abundance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_abun
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_abun
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_abun
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_abun
sd_hedge_abun <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_abun <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_abun / sd_hedge_abun
hedge_abun <- hedge_abun*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_abun <- se_hedge(n1,n2,n3,n4,hedge_abun)
ci_hedge_abun <- bootstrap_hedge_CI(hedge_abun,se_hedge_abun,n1,n2,n3,n4)
#effect size - body mass
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_bodymass
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_bodymass
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_bodymass
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_bodymass
sd_hedge_bodymass <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_bodymass <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_bodymass / sd_hedge_bodymass
hedge_bodymass <- hedge_bodymass*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_bodymass <- se_hedge(n1,n2,n3,n4,hedge_bodymass)
ci_hedge_bodymass <- bootstrap_hedge_CI(hedge_bodymass,se_hedge_bodymass,n1,n2,n3,n4)
#effect size - species richness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_richness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_richness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_richness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_richness
sd_hedge_richness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_richness <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_richness / sd_hedge_richness
hedge_richness <- hedge_richness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_richness <- se_hedge(n1,n2,n3,n4,hedge_richness)
ci_hedge_richness <- bootstrap_hedge_CI(hedge_richness,se_hedge_richness,n1,n2,n3,n4)
#effect size - Pielou's evenness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_evenness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_evenness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_evenness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_evenness
sd_hedge_evenness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_evenness <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_evenness / sd_hedge_evenness
hedge_evenness <- hedge_evenness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_evenness <- se_hedge(n1,n2,n3,n4,hedge_evenness)
ci_hedge_evenness <- bootstrap_hedge_CI(hedge_evenness,se_hedge_evenness,n1,n2,n3,n4)
#effect size - proportionofbasal
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_pob
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_pob
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_pob
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_pob
sd_hedge_pob <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pob <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_pob / sd_hedge_pob
hedge_pob <- hedge_pob*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pob <- se_hedge(n1,n2,n3,n4,hedge_pob)
ci_hedge_pob <- bootstrap_hedge_CI(hedge_pob,se_hedge_pob,n1,n2,n3,n4)
#effect size - proportionofintermediate
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_poi
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_poi
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_poi
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_poi
sd_hedge_poi <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_poi <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_poi / sd_hedge_poi
hedge_poi <- hedge_poi*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_poi <- se_hedge(n1,n2,n3,n4,hedge_poi)
ci_hedge_poi <- bootstrap_hedge_CI(hedge_poi,se_hedge_poi,n1,n2,n3,n4)
#effect size - proportionoftop
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_pot
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_pot
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_pot
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_pot
sd_hedge_pot <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_pot <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_pot / sd_hedge_pot
hedge_pot <- hedge_pot*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_pot <- se_hedge(n1,n2,n3,n4,hedge_pot)
ci_hedge_pot <- bootstrap_hedge_CI(hedge_pot,se_hedge_pot,n1,n2,n3,n4)
#effect size - meantrophiclevel
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_mtl
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_mtl
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_mtl
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_mtl
sd_hedge_mtl <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_mtl <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_mtl / sd_hedge_mtl
hedge_mtl <- hedge_mtl*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_mtl <- se_hedge(n1,n2,n3,n4,hedge_mtl)
ci_hedge_mtl <- bootstrap_hedge_CI(hedge_mtl,se_hedge_mtl,n1,n2,n3,n4)
#effect size - generalitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_generalitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_generalitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_generalitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_generalitySD
sd_hedge_generalitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_generalitySD <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_generalitySD / sd_hedge_generalitySD
hedge_generalitySD <- hedge_generalitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_generalitySD <- se_hedge(n1,n2,n3,n4,hedge_generalitySD)
ci_hedge_generalitySD <- bootstrap_hedge_CI(hedge_generalitySD,se_hedge_generalitySD,n1,n2,n3,n4)
#effect size - vulnerabilitySD
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_vulnerabilitySD
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_vulnerabilitySD
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_vulnerabilitySD
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_vulnerabilitySD
sd_hedge_vulnerabilitySD <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_vulnerabilitySD <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_vulnerabilitySD / sd_hedge_vulnerabilitySD
hedge_vulnerabilitySD <- hedge_vulnerabilitySD*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_vulnerabilitySD <- se_hedge(n1,n2,n3,n4,hedge_vulnerabilitySD)
ci_hedge_vulnerabilitySD <- bootstrap_hedge_CI(hedge_vulnerabilitySD,se_hedge_vulnerabilitySD,n1,n2,n3,n4)
#effect size - linkrichness
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_linkrichness
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_linkrichness
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_linkrichness
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_linkrichness
sd_hedge_linkrichness <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkrichness <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_linkrichness / sd_hedge_linkrichness
hedge_linkrichness <- hedge_linkrichness*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkrichness <- se_hedge(n1,n2,n3,n4,hedge_linkrichness)
ci_hedge_linkrichness <- bootstrap_hedge_CI(hedge_linkrichness,se_hedge_linkrichness,n1,n2,n3,n4)
#effect size - linkagedensity
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_linkagedensity
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_linkagedensity
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_linkagedensity
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_linkagedensity
sd_hedge_linkagedensity <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_linkagedensity <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_linkagedensity / sd_hedge_linkagedensity
hedge_linkagedensity <- hedge_linkagedensity*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_linkagedensity <- se_hedge(n1,n2,n3,n4,hedge_linkagedensity)
ci_hedge_linkagedensity <- bootstrap_hedge_CI(hedge_linkagedensity,se_hedge_linkagedensity,n1,n2,n3,n4)
#effect size - connectance
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_connectance
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_connectance
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_connectance
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_connectance
sd_hedge_connectance <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_connectance <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_connectance / sd_hedge_connectance
hedge_connectance <- hedge_connectance*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_connectance <- se_hedge(n1,n2,n3,n4,hedge_connectance)
ci_hedge_connectance <- bootstrap_hedge_CI(hedge_connectance,se_hedge_connectance,n1,n2,n3,n4)

hedge_928a11 <- data.frame(rbind(ci_hedge_abun,ci_hedge_bodymass,ci_hedge_richness,
                                 ci_hedge_evenness,ci_hedge_pob,ci_hedge_poi,ci_hedge_pot,
                                 ci_hedge_mtl,ci_hedge_generalitySD,ci_hedge_vulnerabilitySD,
                                 ci_hedge_linkrichness,ci_hedge_linkagedensity,ci_hedge_connectance))
colnames(hedge_928a11) <- c("lower_CI","upper_CI")
hedge_928a11$hedge_g <- c(hedge_abun,hedge_bodymass,hedge_richness,hedge_evenness,
                          hedge_pob,hedge_poi,hedge_pot,hedge_mtl,hedge_generalitySD,
                          hedge_vulnerabilitySD,hedge_linkrichness,hedge_linkagedensity,hedge_connectance)
#Vars is square standard error (variance) of hedge's g
hedge_928a11$Vars <- c(se_hedge_abun^2,se_hedge_bodymass^2,se_hedge_richness^2,se_hedge_evenness^2,se_hedge_pob^2,
                       se_hedge_poi^2,se_hedge_pot^2,se_hedge_mtl^2,se_hedge_generalitySD^2,se_hedge_vulnerabilitySD^2,
                       se_hedge_linkrichness^2,se_hedge_linkagedensity^2,se_hedge_connectance^2)
hedge_928a11$Metrics <- c("abun","bodymass","spprichness","evenness",
                          "pob","poi","pot","mtl","generalitySD",
                          "vulnerabilitySD","linkrichness",
                          "linkagedensity","connectance")
hedge_928a11$Metrics <- factor(hedge_928a11$Metrics,levels = c("abun","bodymass","spprichness","evenness",
                                                               "pob","poi","pot","mtl","generalitySD",
                                                               "vulnerabilitySD","linkrichness",
                                                               "linkagedensity","connectance"))
hedge_928a11$MMS <- "9/28a- 11"


## Combine all hedge's g across O&G infrastructure ----
hedge_all <- rbind(hedge_1322a11,hedge_1324b3,hedge_1520b12,hedge_1523d13,
                   hedge_1603d14,hedge_16226,hedge_21112a18,hedge_22296,
                   hedge_29104,hedge_29105A,
                   hedge_29122,hedge_30135,hedge_3029a3,hedge_928a11)

hedge_all$Metrics <- gsub("abun","abundance",hedge_all$Metrics)
hedge_all$Metrics <- gsub("bodymass","body mass",hedge_all$Metrics)
hedge_all$Metrics <- gsub("spprichness","richness",hedge_all$Metrics)
hedge_all$Metrics <- gsub("pob","proportion of basal",hedge_all$Metrics)
hedge_all$Metrics <- gsub("poi","proportion of intermediate",hedge_all$Metrics)
hedge_all$Metrics <- gsub("pot","proportion of top",hedge_all$Metrics)
hedge_all$Metrics <- gsub("mtl","mean trophic level",hedge_all$Metrics)
hedge_all$Metrics <- gsub("linkrichness","link richness",hedge_all$Metrics)
hedge_all$Metrics <- gsub("linkagedensity","linkage density",hedge_all$Metrics)

hedge_all$Metrics <- factor(hedge_all$Metrics,
                            levels=c("connectance","linkage density",
                                     "link richness","vulnerabilitySD",
                                     "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                     "proportion of basal","evenness","richness",
                                     "body mass","abundance"))
unique(hedge_all$MMS)

mod0 <- rma.mv(hedge_g,
               Vars,
               #without intercept (no reference level - focus on estimate and CI of each metric)
               #using~Metrics-1,p value indicate whether estimate is significant different from 0
               #if using ~Metric, p value indicate the difference between each level of metric and reference level
               mods = ~Metrics - 1, 
               test = "t",
               #random = ~ 1|MMS,
               random = list(~ 1|MMS),
               #data=hedge_all)
               data=hedge_all)

summary.rma(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("connectance","linkage density",
                                         "link richness","vulnerabilitySD",
                                         "generalitySD","mean trophic level","proportion of top","proportion of intermediate",
                                         "proportion of basal","evenness","richness",
                                         "body mass","abundance")),
                       data=hedge_all)

resmod0$mod_table

###s2:Extract model estimates#####
s2_ecologicalmetric <- data.frame(resmod0$mod_table)
s2_ecologicalmetric$pval <- mod0$pval #order of metrics is opposite to pval
s2_ecologicalmetric$scenario <- c("scenario 2")


#Combine s1,s2,s3 ecological metric model coefficients####
s1s2s3_ecologicalmetric <- rbind(s1s3_ecologicalmetric,s2_ecologicalmetric)
save(s1s2s3_ecologicalmetric,file="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/s1s2s3ecologicalmetrics.Rdata")
setwd("D:/UoE/Writings/Data Chapter 2/LO/revisions/coding")
load("s1s2s3ecologicalmetrics.Rdata")

s1s2s3_ecologicalmetric <- s1s2s3_ecologicalmetric %>%
  mutate(significance = case_when(
    pval < 0.001 ~ "***",
    pval < 0.01 ~ "**",
    pval < 0.05 ~ "*",
    TRUE ~ "")) %>%
  mutate(name = gsub("Richness","Species richness",name)) %>%
  mutate(name = factor(name,levels = c("Connectance","Linkage density","Link richness",
                                       "VulnerabilitySD","GeneralitySD","Mean trophic level",
                                       "Proportion of top","Proportion of intermediate",
                                       "Proportion of basal","Evenness","Species richness",
                                       "Body mass","Abundance")))

(p_ecologicalmetric <- ggplot(s1s2s3_ecologicalmetric,aes(y=name,x=estimate,group=scenario))+
    geom_vline(xintercept=0,linetype="dashed")+
    geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
    geom_text(aes(label = significance,x=ifelse(estimate < 0,0.1*upperCL,0.1*lowerCL),
                  hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
              size=6,color="black")+
    #scale_y_discrete(labels = function(x) str_wrap(x, width = 14)) +
    facet_grid(~scenario,scales="free")+
    labs(x="Hedge's g")+
    theme_bw(base_size = 14)+
    theme(axis.title.y = element_blank(),
          axis.text = element_text(size=14,colour = "black"),
          strip.text = element_text(size = 16)))

ggsave(p_ecologicalmetric,path = "D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename = "s1s2s3ecologicalmetric.png",,width=10,height=8,dpi=600,bg="white")

s1s2s3_diversity <- s1s2s3_ecologicalmetric %>%
  filter(name %in% c("Abundance","Body mass","Species richness","Evenness"))
s1s2s3_foodweb <- s1s2s3_ecologicalmetric %>%
  filter(name %in% c("Proportion of basal","Proportion of intermediate",
                     "Proportion of top","Mean trophic level","GeneralitySD",
                     "VulnearbilitySD","Link richness","Linkage density","Connectance"))

(p_diversity <- ggplot(s1s2s3_diversity,aes(y=name,x=estimate,group=scenario))+
    geom_vline(xintercept=0,linetype="dashed")+
    geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
    geom_text(aes(label = significance,x=ifelse(estimate < 0,0.1*upperCL,0.1*lowerCL),
                  hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
              size=6,color="black")+
    #scale_y_discrete(labels = function(x) str_wrap(x, width = 14)) +
    facet_grid(~scenario,scales="free")+
    labs(x="Hedge's g")+
    theme_bw(base_size = 14)+
    theme(axis.title.y = element_blank(),
          axis.text = element_text(size=14,colour = "black"),
          strip.text = element_text(size = 16)))

ggsave(p_diversity,path = "D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename = "s1s2s3diversity.png",,width=10,height=4,dpi=600,bg="white")


(p_foodweb <- ggplot(s1s2s3_foodweb,aes(y=name,x=estimate,group=scenario))+
    geom_vline(xintercept=0,linetype="dashed")+
    geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
    geom_text(aes(label = significance,x=ifelse(estimate < 0,0.1*upperCL,0.1*lowerCL),
                  hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
              size=6,color="black")+
    #scale_y_discrete(labels = function(x) str_wrap(x, width = 14)) +
    facet_grid(~scenario,scales="free")+
    labs(x="Hedge's g")+
    theme_bw(base_size = 14)+
    theme(axis.title.y = element_blank(),
          axis.text = element_text(size=14,colour = "black"),
          strip.text = element_text(size = 16)))

ggsave(p_foodweb,path = "D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename = "s1s2s3foodweb.png",,width=10,height=4,dpi=600,bg="white")
