#calculate the mean and variance for each treatment
#calculate the mean change for each treatment
#calculate net intervention effect
#calculate hedge's g for the net effect (net intervention effect / pooled sd)
#calculate standard error of Hedge's g (sqrt(1/n))

rm(list=ls())
#hedge's g stats
library(tidyverse) 
library(ggplot2)
library(ggpubr)
library(patchwork)
library(effsize)
library(metafor)
library(boot)

#S1 and S3 ----

## Data loading ----
setwd("D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/Essex data repository")
load("s1s3chemical.Rdata")
df1 <- s1s3chemical

## Boxplots comparing means of raw data----
df1$Treatment <- factor(df1$Treatment,levels = c("pre Impact","pre Control","post Impact","post Control"))
df1_s1 <- df1[df1$TargetMMS!="North West Hutton",]
df1_s3 <- df1[df1$TargetMMS=="North West Hutton",]
compare_means(total.hydrocarbons ~ Treatment,data=df1_s1)
my_comparisons <- list(c("pre Impact","post Impact"))
p1 <- ggplot(data=df1_s1,aes(x=Treatment,y=total.hydrocarbons))+
  geom_boxplot()+
  labs(y="Total hydrocarbons(µg/g)",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14) 
p1
compare_means(total.hydrocarbons ~ Treatment,data=df1_s3)
p5 <- ggplot(data=df1_s3,aes(x=Treatment,y=total.hydrocarbons))+
  geom_boxplot()+
  labs(y="Total hydrocarbons(µg/g)",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14) 
p5

compare_means(heavy.metal ~ Treatment,data=df1_s1)
p2 <- ggplot(data=df1_s1,aes(x=Treatment,y=heavy.metal))+
  geom_boxplot()+
  labs(y="Heavy metals(µg/g)",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
compare_means(heavy.metal ~ Treatment,data=df1_s3)
p6 <- ggplot(data=df1_s3,aes(x=Treatment,y=heavy.metal))+
  geom_boxplot()+
  labs(y="Heavy metals(µg/g)",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

compare_means(total.Ba ~ Treatment, data=df1_s1)
compare_means(total.Ba ~ Treatment, data=df1_s3)
ggplot(data=df1_s1,aes(x=Treatment,y=total.Ba))+
  geom_boxplot()+
  labs(y="Total Barium",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
ggplot(data=df1_s3,aes(x=Treatment,y=total.Ba))+
  geom_boxplot()+
  labs(y="Total Barium",x=NULL) +
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

compare_means(Cu ~ Treatment, data=df1_s1)
compare_means(Cu ~ Treatment, data=df1_s3)
ggplot(data=df1_s1,aes(x=Treatment,y=Cu))+
  geom_boxplot()+
  labs(y="Cu",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
ggplot(data=df1_s3,aes(x=Treatment,y=Cu))+
  geom_boxplot()+
  labs(y="Cu",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

compare_means(Ni ~ Treatment, data=df1_s1)
compare_means(Ni ~ Treatment, data=df1_s3)
ggplot(data=df1_s1,aes(x=Treatment,y=Ni))+
  geom_boxplot()+
  labs(y="Ni",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
ggplot(data=df1_s3,aes(x=Treatment,y=Ni))+
  geom_boxplot()+
  labs(y="Ni",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

compare_means(Pb ~ Treatment,data=df1_s1)
compare_means(Pb ~ Treatment,data=df1_s3)
ggplot(data=df1_s1,aes(x=Treatment,y=Pb))+
  geom_boxplot()+
  labs(y="Pb",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
ggplot(data=df1_s3,aes(x=Treatment,y=Pb))+
  geom_boxplot()+
  labs(y="Pb",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

compare_means(Zn ~ Treatment,data=df1_s1)
compare_means(Zn ~ Treatment,data=df1_s3)
ggplot(data=df1_s1,aes(x=Treatment,y=Zn))+
  geom_boxplot()+
  labs(y="Zn",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)
ggplot(data=df1_s3,aes(x=Treatment,y=Zn))+
  geom_boxplot()+
  labs(y="Zn",x=NULL)+
  stat_compare_means(comparisons = my_comparisons,label = "p.signif")+
  theme_bw(base_size=14)

## Functions ready----
safe_sd <- function(x) {
  if (sum(!is.na(x)) <= 1) { # Correctly checks if there's only 1 or 0 valid observations
    return(0)
  } else {
    return(sd(x, na.rm = TRUE))
  }
}

#pooled standard deviation to calculate hedge's g (used to be divided by delta mean impact and delta mean control)
sd_hedge <- function(n1,n2,n3,n4,sd1,sd2,sd3,sd4){ #raw sample size at the impact/control before and after the intervention
  n = n1+n2+n3+n4
  x1 = (n1-1)*sd1^2
  x2 = (n2-1)*sd2^2
  x3 = (n3-1)*sd3^2
  x4 = (n4-1)*sd4^2
  sd_hedge = sqrt((x1+x2+x3+x4)/(n-4))
  return(sd_hedge)
}

#hedge = (delta_meanimpact-delta_meancontrol)/pooled standard deviation(sd_hedge)
#hedge_corrected = hedge*(1-3/(4*(N-2)-1))

se_hedge <- function(n1,n2,n3,n4,hedge){ #n1,n3 prepost impact;n2,n4 prepost control
  n=n1+n2+n3+n4
  n_impact = n1+n3
  n_control = n2+n4
  #small sample correction incorporated below (J = 1 - 3/(4(N-2)-1))
  J = 1 - 3 / (4*(n-2)-1)
  var_hedge = (n / (n_impact * n_control)) + (hedge^2 / (2 * n))
  return(sqrt(var_hedge) * J)
}


#this bootstrap function assumes t-distribution
bootstrap_hedge_CI <- function(hedge, se_hedge, n1, n2, n3, n4, R = 1000, conf.level = 0.95) {
  # Calculate degrees of freedom for t-distribution
  n = n1 + n2 + n3 + n4
  df = n - 4
  # Generate bootstrap samples using t-distribution
  boot_samples <- rt(R, df = df) * se_hedge + hedge
  # Compute percentile CI
  lower_CI <- quantile(boot_samples, (1 - conf.level) / 2, type = 6) # bias-corrected percentile bootstrap
  upper_CI <- quantile(boot_samples, (1 + conf.level) / 2, type = 6)
  # Return results
  return(CIs = c(lower_CI, upper_CI))
}


## Calculate the mean and variance for each treatment----
#mean and variance of the impact before the intervention
meanimpact_pre <- df1 %>%
  filter(Treatment == "pre Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdimpact_pre <- df1 %>%
  filter(Treatment == "pre Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )

#mean and variance of the impact after the intervention
meanimpact_post <- df1 %>%
  filter(Treatment == "post Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdimpact_post <- df1 %>%
  filter(Treatment == "post Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )

#mean and variance of the control before the intervention
meancontrol_pre <- df1 %>%
  filter(Treatment == "pre Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdcontrol_pre <- df1 %>%
  filter(Treatment == "pre Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )


#mean and variance of the control after the intervention
meancontrol_post <- df1 %>%
  filter(Treatment == "post Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdcontrol_post <- df1 %>%
  filter(Treatment == "post Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )

#Calculate the raw sample size for each treatment
samplesize <- df1 %>%
  group_by(TargetMMS,Treatment) %>%
  summarise(n_sample = n())


## Calculate the mean change for each treatment----
mmslist <- meancontrol_post$TargetMMS
meanimpact_post$TargetMMS <- NULL
meanimpact_pre$TargetMMS <- NULL
meancontrol_post$TargetMMS <- NULL
meancontrol_pre$TargetMMS <- NULL
delta_meanimpact <- meanimpact_post - meanimpact_pre
delta_meancontrol <- meancontrol_post - meancontrol_pre
delta_meanimpact$TargetMMS <- mmslist
delta_meancontrol$TargetMMS <- mmslist


## Calculate the net intervention effect----
delta_meanimpact$TargetMMS <- NULL
delta_meancontrol$TargetMMS <- NULL
neteffect <- delta_meanimpact - delta_meancontrol
neteffect$TargetMMS <- mmslist


## Calculate Hedge's g for the net intervention effect for each O&G infrastructure----

#mms=29/07-10Y

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="29/07-10Y",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/07-10Y",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/07-10Y",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/07-10Y",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/07-10Y",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="29/07-10Y",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_290710Y <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                  ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                  ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_290710Y) <- c("lower_CI","upper_CI")
hedge_290710Y$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                           hedge_Ni,hedge_Pb,hedge_Zn,
                           hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_290710Y$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                        se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                        se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_290710Y$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                           "Ni","Pb","Zn",
                           "Silt Clay","Median Grain")
hedge_290710Y$Metrics <- factor(hedge_290710Y$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                                 "Ni","Pb","Zn",
                                                                 "Silt Clay","Median Grain"))
hedge_290710Y$MMS <- "29/07-10Y"


#mms=44/12- 1

#effect size - total.hydrocarbons(not available)

#effect size - heavy.metals (not available)

#effect size - total.Ba (not available)

#effect size - Cu(not available)

#effect size - Ni(not available)

#effect size - Pb(not available)

#effect size - Zn(not available)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="44/12- 1",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="44/12- 1",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="44/12- 1",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="44/12- 1",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="44/12- 1",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="44/12- 1",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="44/12- 1",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_44121 <- data.frame(rbind(ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_44121) <- c("lower_CI","upper_CI")
hedge_44121$hedge_g <- c(hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_44121$Vars <- c(se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_44121$Metrics <- c("Silt Clay","Median Grain")
hedge_44121$Metrics <- factor(hedge_44121$Metrics,levels = c("Silt Clay","Median Grain"))
hedge_44121$MMS <- "44/12- 1"


#mms = "North West Hutton"

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="North West Hutton",]$n_sample
n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="North West Hutton",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="North West Hutton",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="North West Hutton",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="North West Hutton",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="North West Hutton",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="North West Hutton",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_NWH <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                              ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                              ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_NWH) <- c("lower_CI","upper_CI")
hedge_NWH$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                       hedge_Ni,hedge_Pb,hedge_Zn,
                       hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_NWH$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                    se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                    se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_NWH$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                       "Ni","Pb","Zn",
                       "Silt Clay","Median Grain")
hedge_NWH$Metrics <- factor(hedge_NWH$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                         "Ni","Pb","Zn",
                                                         "Silt Clay","Median Grain"))
hedge_NWH$MMS <- "North West Hutton"


# #mms=Moray Firth 11/25
# #effect size - total.hydrocarbons (not available)
# #effect size - heavy.metals
# n1 = samplesize[samplesize$Treatment=="pre Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n2 = samplesize[samplesize$Treatment=="pre Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n3 = samplesize[samplesize$Treatment=="post Impact" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# n4 = samplesize[samplesize$Treatment=="post Control" & samplesize$TargetMMS=="Moray Firth 11/25",]$n_sample
# sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="Moray Firth 11/25",]$sd_metals
# sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="Moray Firth 11/25",]$sd_metals
# sd3 = sdimpact_post[sdimpact_post$TargetMMS=="Moray Firth 11/25",]$sd_metals
# sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="Moray Firth 11/25",]$sd_metals
# sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
# hedge_metal <- neteffect[neteffect$TargetMMS=="Moray Firth 11/25",]$mean_metals / sd_hedge_metal
# hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
# se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
# ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)
# #effect size - other individual elements(not available)
# 
# hedge_MorayFirth1125 <- data.frame(rbind(ci_hedge_metal))
# colnames(hedge_MorayFirth1125) <- c("lower_CI","upper_CI")
# hedge_MorayFirth1125$hedge_g <- c(hedge_metal)
# #Vars is square standard error (variance) of hedge's g
# hedge_MorayFirth1125$Vars <- c(se_hedge_metal^2)
# hedge_MorayFirth1125$Metrics <- c("heavy metals")
# hedge_MorayFirth1125$Metrics <- factor(hedge_MorayFirth1125$Metrics,levels = c("heavy metals"))
# hedge_MorayFirth1125$MMS <- "Moray Firth 11/25"


## Combine all hedge's g across O&G infrastructure ----
#hedge_all <- rbind(hedge_290710Y,hedge_44121,hedge_NWH,hedge_MorayFirth1125)
hedge_all <- rbind(hedge_290710Y,hedge_44121,hedge_NWH)

library(orchaRd)
library(flextable)

# sievegear <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton","Moray Firth 11/25"),
#                         SieveGear=c("H_Day Grab","1_Day Grab","H_Day Grab","Both_NotKnown"))
# hedge_all2 <- merge(hedge_all,sievegear,by="MMS",all.x=T)

# ###if orchard plot wants to split into well and plat separately
# unique(hedge_all2$MMS)
# MMStype <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton","Moray Firth 11/25"),
#                       Type=c("Well","Well","Platform","Well"))
# hedge_all3 <- merge(hedge_all2,MMStype,by="MMS",all.x=T)
MMStype <- data.frame(MMS=c("29/07-10Y","44/12- 1","North West Hutton"),
                      Type=c("Well","Well","Platform"))
hedge_all3 <- hedge_all %>%
  left_join(MMStype, by = c("MMS"))

hedge_all3_well <- hedge_all3[hedge_all3$Type=="Well",]
hedge_all3_plat <- hedge_all3[hedge_all3$Type=="Platform",]

#try wells
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test = "t",
               random = ~ 1|MMS,
               data=hedge_all3_well)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("Median Grain","Silt Clay","Zn","Pb",
                                         "Ni","Cu","total Ba",
                                         "heavy metals","total hydrocarbons")),
                       data=hedge_all3_well)
resmod0$mod_table
(p1 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("gray","grey","gray","gray","gray","gray","gray","gray","gray"))+
    scale_color_manual(values=c("gray","grey","gray","gray","gray","gray","gray","gray","gray"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

### s1:Extract model estimates for ggplot2####
s1_chemical <- data.frame(resmod0$mod_table)
s1_chemical$pval <- rev(mod0$pval)
s1_chemical$scenario <- c("scenario 1")

#retain hydrocarbons and metals for wells
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test = "t",
               random = ~ 1|MMS,
               data=hedge_all3_well)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("heavy metals","total hydrocarbons")),
                       subset=T,
                       data=hedge_all3_well)
resmod0$mod_table
(p1 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    scale_fill_manual(values=c("gray","grey"))+
    scale_color_manual(values=c("gray","grey"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p1,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s1_Chemical.png",width = 4,height=4,bg="white",dpi=600)

#retain metals for wells
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               test = "t",
               random = ~ 1|MMS,
               data=hedge_all3_well)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("Zn","Pb","Ni","Cu","total Ba")),
                       subset=T,
                       data=hedge_all3_well)
resmod0$mod_table
(p1.1 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    scale_fill_manual(values=c("gray","grey","gray","grey","grey"))+
    scale_color_manual(values=c("gray","grey","gray","grey","grey"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p1.1,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s1_metals.png",width = 4,height=4,bg="white",dpi=600)

#try platform
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               # test = "t",
               # random = ~ 1|MMS,
               data=hedge_all3_plat)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("Median Grain","Silt Clay","Zn","Pb",
                                         "Ni","Cu","total Ba",
                                         "heavy metals","total hydrocarbons")),
                       data=hedge_all3_plat)
resmod0$mod_table
(p1 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","grey","grey","grey","black","white","grey","black"))+
    scale_color_manual(values=c("gray","grey","gray","grey","gray","grey","gray","grey","grey"))+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

### s3:Extract model estimates for ggplot2####
s3_chemical <- data.frame(resmod0$mod_table)
s3_chemical$pval <- rev(mod0$pval)
s3_chemical$scenario <- c("scenario 3")

#retain hydrocarbons and metals for platform
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               #test = "t", #to align with ggplot2
               #random = ~ 1|MMS,
               data=hedge_all3_plat)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("heavy metals","total hydrocarbons")),
                       subset=T,
                       data=hedge_all3_plat)
resmod0$mod_table
(p2 <- orchard_plot(resmod0,xlab="Hedge's g",
                    group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","black"))+
    scale_color_manual(values=c("gray","grey"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p2,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s3_Chemical.png",width = 4,height=4,bg="white",dpi=600)

#retain individual metals for platform
mod0 <- rma.mv(hedge_g,
               Vars,
               mods = ~Metrics-1,
               #test = "t", #to align with ggplot2
               #random = ~ 1|MMS,
               data=hedge_all3_plat)
summary(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("Zn","Pb","Ni","Cu","total Ba")),
                       subset=T,
                       data=hedge_all3_plat)
resmod0$mod_table
(p2.1 <- orchard_plot(resmod0,xlab="Hedge's g",
                      group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    #scale_x_discrete(labels = function(x) str_replace_all(x," ","\n"))+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","gray","black","white"))+
    scale_color_manual(values=c("gray","grey","gray","grey","grey"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

ggsave(p2.1,path="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename="s3_metals.png",width = 4,height=4,bg="white",dpi=600)


###s1s3:Combine model estimates####
s1s3 <- rbind(s1_chemical,s3_chemical)

# S2 ----
## Data loading ----
setwd("D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/Essex data repository")
load("s2chemical.Rdata")
df1 <- s2chemical

## Calculate the mean and variance for each treatment----
#mean and variance of the impact before the intervention
meanimpact_pre <- df1 %>%
  filter(Treatment == "Early Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdimpact_pre <- df1 %>%
  filter(Treatment == "Early Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )

#mean and variance of the impact after the intervention
meanimpact_post <- df1 %>%
  filter(Treatment == "Later Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdimpact_post <- df1 %>%
  filter(Treatment == "Later Impact") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )

#mean and variance of the control before the intervention
meancontrol_pre <- df1 %>%
  filter(Treatment == "Early Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdcontrol_pre <- df1 %>%
  filter(Treatment == "Early Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )


#mean and variance of the control after the intervention
meancontrol_post <- df1 %>%
  filter(Treatment == "Later Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    mean_hydrocarbons = mean(total.hydrocarbons,na.rm=T),
    mean_metals = mean(heavy.metal,na.rm=T),
    mean_Ba = mean(total.Ba,na.rm=T),
    mean_Cu = mean(Cu,na.rm=T),
    mean_Ni = mean(Ni,na.rm=T),
    mean_Pb = mean(Pb,na.rm=T),
    mean_Zn = mean(Zn,na.rm=T),
    mean_SiltClay = mean(Silt.Clay,na.rm=T),
    mean_MedianGrain = mean(Median.Grain,na.rm=T)
  )

sdcontrol_post <- df1 %>%
  filter(Treatment == "Later Control") %>%
  group_by(TargetMMS) %>%
  summarise(
    sd_hydrocarbons = safe_sd(total.hydrocarbons),
    sd_metals = safe_sd(heavy.metal),
    sd_Ba = safe_sd(total.Ba),
    sd_Cu = safe_sd(Cu),
    sd_Ni = safe_sd(Ni),
    sd_Pb = safe_sd(Pb),
    sd_Zn = safe_sd(Zn),
    sd_SiltClay = safe_sd(Silt.Clay),
    sd_MedianGrain = safe_sd(Median.Grain)
  )


#Calculate the raw sample size for each treatment
samplesize <- df1 %>%
  group_by(TargetMMS,Treatment) %>%
  summarise(n_sample = n())


## Calculate the mean change for each treatment----
mmslist <- meancontrol_post$TargetMMS
meanimpact_post$TargetMMS <- NULL
meanimpact_pre$TargetMMS <- NULL
meancontrol_post$TargetMMS <- NULL
meancontrol_pre$TargetMMS <- NULL
delta_meanimpact <- meanimpact_post - meanimpact_pre
delta_meancontrol <- meancontrol_post - meancontrol_pre
delta_meanimpact$TargetMMS <- mmslist
delta_meancontrol$TargetMMS <- mmslist


## Calculate the net intervention effect----
delta_meanimpact$TargetMMS <- NULL
delta_meancontrol$TargetMMS <- NULL
neteffect <- delta_meanimpact - delta_meancontrol
neteffect$TargetMMS <- mmslist


#this bootstrap function assumes t-distribution
bootstrap_hedge_CI <- function(hedge, se_hedge, n1, n2, n3, n4, R = 1000, conf.level = 0.95) {
  # Calculate degrees of freedom for t-distribution
  n = n1 + n2 + n3 + n4
  df = n - 4
  # Generate bootstrap samples using t-distribution
  boot_samples <- rt(R, df = df) * se_hedge + hedge
  # Compute percentile CI
  lower_CI <- quantile(boot_samples, (1 - conf.level) / 2, type = 6) # bias-corrected percentile bootstrap
  upper_CI <- quantile(boot_samples, (1 + conf.level) / 2, type = 6)
  # Return results
  return(CIs = c(lower_CI, upper_CI))
}


## Calculate Hedge's g for the net intervention effect for each O&G ifnrastructure----

#mms = 13/22a- 11

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)
#effect size - heavy.metals(not available)
#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)
#effect size - Cu(not available)
#effect size - Ni(not available)
#effect size - Pb(not available)
#effect size - Zn(not available)
#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/22a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/22a- 11",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/22a- 11",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/22a- 11",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/22a- 11",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="13/22a- 11",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_1322a11 <- data.frame(rbind(ci_hedge_th,ci_hedge_Ba,
                                  ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_1322a11) <- c("lower_CI","upper_CI")
hedge_1322a11$hedge_g <- c(hedge_th,hedge_Ba,hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_1322a11$Vars <- c(se_hedge_th^2,se_hedge_Ba^2,
                        se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_1322a11$Metrics <- c("total hydrocarbons","total Ba",
                           "Silt Clay","Median Grain")
hedge_1322a11$Metrics <- factor(hedge_1322a11$Metrics,levels = c("total hydrocarbons","total Ba",
                                                                 "Silt Clay","Median Grain"))
hedge_1322a11$MMS <- "13/22a- 11"



#mms = 13/24b- 3

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="13/24b- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="13/24b- 3",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="13/24b- 3",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="13/24b- 3",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="13/24b- 3",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="13/24b- 3",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_1324b3 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                 ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                 ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_1324b3) <- c("lower_CI","upper_CI")
hedge_1324b3$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                          hedge_Ni,hedge_Pb,hedge_Zn,
                          hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_1324b3$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                       se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                       se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_1324b3$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                          "Ni","Pb","Zn",
                          "Silt Clay","Median Grain")
hedge_1324b3$Metrics <- factor(hedge_1324b3$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                               "Ni","Pb","Zn",
                                                               "Silt Clay","Median Grain"))
hedge_1324b3$MMS <- "13/24b- 3"


#mms = 15/20b- 12

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)

#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/20b- 12",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/20b- 12",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/20b- 12",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/20b- 12",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/20b- 12",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="15/20b- 12",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_1520b12 <- data.frame(rbind(ci_hedge_th,ci_hedge_Ba,
                                  ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_1520b12) <- c("lower_CI","upper_CI")
hedge_1520b12$hedge_g <- c(hedge_th,hedge_Ba,
                           hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_1520b12$Vars <- c(se_hedge_th^2,se_hedge_Ba^2,
                        se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_1520b12$Metrics <- c("total hydrocarbons","total Ba",
                           "Silt Clay","Median Grain")
hedge_1520b12$Metrics <- factor(hedge_1520b12$Metrics,levels = c("total hydrocarbons","total Ba",
                                                                 "Silt Clay","Median Grain"))
hedge_1520b12$MMS <- "15/20b- 12"


#mms = 15/23d- 13


#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="15/23d- 13",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="15/23d- 13",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="15/23d- 13",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="15/23d- 13",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="15/23d- 13",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="15/23d- 13",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_1523d13 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                  ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                  ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_1523d13) <- c("lower_CI","upper_CI")
hedge_1523d13$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                           hedge_Ni,hedge_Pb,hedge_Zn,
                           hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_1523d13$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                        se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                        se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_1523d13$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                           "Ni","Pb","Zn",
                           "Silt Clay","Median Grain")
hedge_1523d13$Metrics <- factor(hedge_1523d13$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                                 "Ni","Pb","Zn",
                                                                 "Silt Clay","Median Grain"))
hedge_1523d13$MMS <- "15/23d- 13"

#mms = 15/29a- 7

#effect size - total.hydrocarbons
#effect size - heavy.metals
#effect size - total.Ba
#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
#effect size - Median.Grain

#mms = 16/03d- 14

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/03d- 14",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/03d- 14",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/03d- 14",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/03d- 14",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/03d- 14",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="16/03d- 14",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_1603d14 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                  ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                  ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_1603d14) <- c("lower_CI","upper_CI")
hedge_1603d14$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                           hedge_Ni,hedge_Pb,hedge_Zn,
                           hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_1603d14$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                        se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                        se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_1603d14$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                           "Ni","Pb","Zn",
                           "Silt Clay","Median Grain")
hedge_1603d14$Metrics <- factor(hedge_1603d14$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                                 "Ni","Pb","Zn",
                                                                 "Silt Clay","Median Grain"))
hedge_1603d14$MMS <- "16/03d- 14"


#mms = 16/22- 6

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="16/22- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="16/22- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="16/22- 6",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="16/22- 6",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="16/22- 6",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="16/22- 6",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="16/22- 6",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_16226 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_16226) <- c("lower_CI","upper_CI")
hedge_16226$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                         hedge_Ni,hedge_Pb,hedge_Zn,
                         hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_16226$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                      se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                      se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_16226$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                         "Ni","Pb","Zn",
                         "Silt Clay","Median Grain")
hedge_16226$Metrics <- factor(hedge_16226$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                             "Ni","Pb","Zn",
                                                             "Silt Clay","Median Grain"))
hedge_16226$MMS <- "16/22- 6"


#mms = 211/12a- 18

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="211/12a- 18",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="211/12a- 18",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="211/12a- 18",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="211/12a- 18",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="211/12a- 18",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="211/12a- 18",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
#effect size - total.Ba
#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
#effect size - Median.Grain

hedge_21112a18 <- data.frame(rbind(ci_hedge_th))
colnames(hedge_21112a18) <- c("lower_CI","upper_CI")
hedge_21112a18$hedge_g <- c(hedge_th)
#Vars is square standard error (variance) of hedge's g
hedge_21112a18$Vars <- c(se_hedge_th^2)
hedge_21112a18$Metrics <- c("total hydrocarbons")
hedge_21112a18$Metrics <- factor(hedge_21112a18$Metrics,levels = c("total hydrocarbons"))
hedge_21112a18$MMS <- "211/12a- 18"


#mms = 22/29- 6

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="22/29- 6",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="22/29- 6",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="22/29- 6",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="22/29- 6",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="22/29- 6",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="22/29- 6",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="22/29- 6",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)

#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
#effect size - Median.Grain

hedge_22296 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba))
colnames(hedge_22296) <- c("lower_CI","upper_CI")
hedge_22296$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba)
#Vars is square standard error (variance) of hedge's g
hedge_22296$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2)
hedge_22296$Metrics <- c("total hydrocarbons","heavy metals","total Ba")
hedge_22296$Metrics <- factor(hedge_22296$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba"))
hedge_22296$MMS <- "22/29- 6"

#mms = 29/10- 4

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 4",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 4",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 4",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 4",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 4",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 4",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="29/10- 4",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)

#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
#effect size - Median.Grain
hedge_29104 <- data.frame(rbind(ci_hedge_th,ci_hedge_Ba))
colnames(hedge_29104) <- c("lower_CI","upper_CI")
hedge_29104$hedge_g <- c(hedge_th,hedge_Ba)
#Vars is square standard error (variance) of hedge's g
hedge_29104$Vars <- c(se_hedge_th^2,se_hedge_Ba^2)
hedge_29104$Metrics <- c("total hydrocarbons","total Ba")
hedge_29104$Metrics <- factor(hedge_29104$Metrics,levels = c("total hydrocarbons","total Ba"))
hedge_29104$MMS <- "29/10- 4"


#mms = 29/10- 5A

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/10- 5A",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/10- 5A",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/10- 5A",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/10- 5A",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/10- 5A",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="29/10- 5A",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)

#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
#effect size - Median.Grain

hedge_29105A <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba))
colnames(hedge_29105A) <- c("lower_CI","upper_CI")
hedge_29105A$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba)
#Vars is square standard error (variance) of hedge's g
hedge_29105A$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2)
hedge_29105A$Metrics <- c("total hydrocarbons","heavy metals","total Ba")
hedge_29105A$Metrics <- factor(hedge_29105A$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba"))
hedge_29105A$MMS <- "29/10- 5A"


#mms = 29/12- 2

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="29/12- 2",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="29/12- 2",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="29/12- 2",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="29/12- 2",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="29/12- 2",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="29/12- 2",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="29/12- 2",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_29122 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,ci_hedge_Cu,
                                ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_29122) <- c("lower_CI","upper_CI")
hedge_29122$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,hedge_Cu,
                         hedge_Ni,hedge_Pb,hedge_Zn,
                         hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_29122$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,se_hedge_Cu^2,
                      se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                      se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_29122$Metrics <- c("total hydrocarbons","heavy metals","total Ba","Cu",
                         "Ni","Pb","Zn",
                         "Silt Clay","Median Grain")
hedge_29122$Metrics <- factor(hedge_29122$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba","Cu",
                                                             "Ni","Pb","Zn",
                                                             "Silt Clay","Median Grain"))
hedge_29122$MMS <- "29/12- 2"


#mms = 30/13- 5

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)
#effect size - heavy.metals
#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)
#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/13- 5",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/13- 5",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/13- 5",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/13- 5",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/13- 5",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/13- 5",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="30/13- 5",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_30135 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,
                                ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_30135) <- c("lower_CI","upper_CI")
hedge_30135$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,
                         hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_30135$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,
                      se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_30135$Metrics <- c("total hydrocarbons","heavy metals","total Ba",
                         "Silt Clay","Median Grain")
hedge_30135$Metrics <- factor(hedge_30135$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba",
                                                             "Silt Clay","Median Grain"))
hedge_30135$MMS <- "30/13- 5"


#mms = 30/29a- 3

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals

#effect size - total.Ba
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_Ba
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_Ba
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_Ba
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_Ba
sd_hedge_Ba <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ba <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_Ba / sd_hedge_Ba
hedge_Ba <- hedge_Ba*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ba <- se_hedge(n1,n2,n3,n4,hedge_Ba)
ci_hedge_Ba <- bootstrap_hedge_CI(hedge_Ba,se_hedge_Ba,n1,n2,n3,n4)


#effect size - Cu
#effect size - Ni
#effect size - Pb
#effect size - Zn
#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="30/29a- 3",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="30/29a- 3",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="30/29a- 3",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="30/29a- 3",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="30/29a- 3",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="30/29a- 3",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_3029a3 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Ba,
                                 ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_3029a3) <- c("lower_CI","upper_CI")
hedge_3029a3$hedge_g <- c(hedge_th,hedge_metal,hedge_Ba,
                          hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_3029a3$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Ba^2,
                       se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_3029a3$Metrics <- c("total hydrocarbons","heavy metals","total Ba",
                          "Silt Clay","Median Grain")
hedge_3029a3$Metrics <- factor(hedge_3029a3$Metrics,levels = c("total hydrocarbons","heavy metals","total Ba",
                                                               "Silt Clay","Median Grain"))
hedge_3029a3$MMS <- "30/29a- 3"


#mms = 9/28a- 11

#effect size - total.hydrocarbons
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_hydrocarbons
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_hydrocarbons
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_hydrocarbons
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_hydrocarbons
sd_hedge_th <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_th <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_hydrocarbons / sd_hedge_th
hedge_th <- hedge_th*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_th <- se_hedge(n1,n2,n3,n4,hedge_th)
ci_hedge_th <- bootstrap_hedge_CI(hedge_th,se_hedge_th,n1,n2,n3,n4)

#effect size - heavy.metals
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_metals
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_metals
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_metals
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_metals
sd_hedge_metal <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_metal <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_metals / sd_hedge_metal
hedge_metal <- hedge_metal*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_metal <- se_hedge(n1,n2,n3,n4,hedge_metal)
ci_hedge_metal <- bootstrap_hedge_CI(hedge_metal,se_hedge_metal,n1,n2,n3,n4)

#effect size - total.Ba
#effect size - Cu
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_Cu
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_Cu
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_Cu
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_Cu
sd_hedge_Cu <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Cu <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_Cu / sd_hedge_Cu
hedge_Cu <- hedge_Cu*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Cu <- se_hedge(n1,n2,n3,n4,hedge_Cu)
ci_hedge_Cu <- bootstrap_hedge_CI(hedge_Cu,se_hedge_Cu,n1,n2,n3,n4)

#effect size - Ni
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_Ni
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_Ni
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_Ni
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_Ni
sd_hedge_Ni <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Ni <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_Ni / sd_hedge_Ni
hedge_Ni <- hedge_Ni*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Ni <- se_hedge(n1,n2,n3,n4,hedge_Ni)
ci_hedge_Ni <- bootstrap_hedge_CI(hedge_Ni,se_hedge_Ni,n1,n2,n3,n4)

#effect size - Pb
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_Pb
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_Pb
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_Pb
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_Pb
sd_hedge_Pb <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Pb <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_Pb / sd_hedge_Pb
hedge_Pb <- hedge_Pb*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Pb <- se_hedge(n1,n2,n3,n4,hedge_Pb)
ci_hedge_Pb <- bootstrap_hedge_CI(hedge_Pb,se_hedge_Pb,n1,n2,n3,n4)

#effect size - Zn
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_Zn
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_Zn
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_Zn
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_Zn
sd_hedge_Zn <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_Zn <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_Zn / sd_hedge_Zn
hedge_Zn <- hedge_Zn*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_Zn <- se_hedge(n1,n2,n3,n4,hedge_Zn)
ci_hedge_Zn <- bootstrap_hedge_CI(hedge_Zn,se_hedge_Zn,n1,n2,n3,n4)

#effect size - Silt.Clay
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_SiltClay
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_SiltClay
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_SiltClay
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_SiltClay
sd_hedge_SiltClay <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_SiltClay <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_SiltClay / sd_hedge_SiltClay
hedge_SiltClay <- hedge_SiltClay*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_SiltClay <- se_hedge(n1,n2,n3,n4,hedge_SiltClay)
ci_hedge_SiltClay <- bootstrap_hedge_CI(hedge_SiltClay,se_hedge_SiltClay,n1,n2,n3,n4)

#effect size - Median.Grain
n1 = samplesize[samplesize$Treatment=="Early Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n2 = samplesize[samplesize$Treatment=="Early Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n3 = samplesize[samplesize$Treatment=="Later Impact" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
n4 = samplesize[samplesize$Treatment=="Later Control" & samplesize$TargetMMS=="9/28a- 11",]$n_sample
sd1 = sdimpact_pre[sdimpact_pre$TargetMMS=="9/28a- 11",]$sd_MedianGrain
sd2 = sdcontrol_pre[sdcontrol_pre$TargetMMS=="9/28a- 11",]$sd_MedianGrain
sd3 = sdimpact_post[sdimpact_post$TargetMMS=="9/28a- 11",]$sd_MedianGrain
sd4 = sdcontrol_post[sdcontrol_post$TargetMMS=="9/28a- 11",]$sd_MedianGrain
sd_hedge_MedianGrain <- sd_hedge(n1,n2,n3,n4,sd1,sd2,sd3,sd4)
hedge_MedianGrain <- neteffect[neteffect$TargetMMS=="9/28a- 11",]$mean_MedianGrain / sd_hedge_MedianGrain
hedge_MedianGrain <- hedge_MedianGrain*(1-3/(4*(n1+n2+n3+n4)-1))
se_hedge_MedianGrain <- se_hedge(n1,n2,n3,n4,hedge_MedianGrain)
ci_hedge_MedianGrain <- bootstrap_hedge_CI(hedge_MedianGrain,se_hedge_MedianGrain,n1,n2,n3,n4)

hedge_928a11 <- data.frame(rbind(ci_hedge_th,ci_hedge_metal,ci_hedge_Cu,
                                 ci_hedge_Ni,ci_hedge_Pb,ci_hedge_Zn,
                                 ci_hedge_SiltClay,ci_hedge_MedianGrain))
colnames(hedge_928a11) <- c("lower_CI","upper_CI")
hedge_928a11$hedge_g <- c(hedge_th,hedge_metal,hedge_Cu,
                          hedge_Ni,hedge_Pb,hedge_Zn,
                          hedge_SiltClay,hedge_MedianGrain)
#Vars is square standard error (variance) of hedge's g
hedge_928a11$Vars <- c(se_hedge_th^2,se_hedge_metal^2,se_hedge_Cu^2,
                       se_hedge_Ni^2,se_hedge_Pb^2,se_hedge_Zn^2,
                       se_hedge_SiltClay^2,se_hedge_MedianGrain^2)
hedge_928a11$Metrics <- c("total hydrocarbons","heavy metals","Cu",
                          "Ni","Pb","Zn",
                          "Silt Clay","Median Grain")
hedge_928a11$Metrics <- factor(hedge_928a11$Metrics,levels = c("total hydrocarbons","heavy metals","Cu",
                                                               "Ni","Pb","Zn",
                                                               "Silt Clay","Median Grain"))
hedge_928a11$MMS <- "9/28a- 11"


## Combine all hedge's g across O&G infrastructure ----
hedge_all <- rbind(hedge_1322a11,hedge_1324b3,hedge_1520b12,hedge_1523d13,
                   hedge_1603d14,hedge_16226,hedge_21112a18,
                   hedge_22296,hedge_29104,hedge_29105A,
                   hedge_29122,hedge_30135,hedge_3029a3,hedge_928a11)

library(orchaRd)

mod0 <- rma.mv(hedge_g,
               Vars,
               #without intercept (no reference level - focus on estimate and CI of each metric)
               #using~Metrics-1,p value indicate whether estimate is significant different from 0
               #if using ~Metric, p value indicate the difference between each level of metric and reference level
               mods = ~Metrics - 1, 
               test = "t",
               #random = ~ 1|MMS,
               random = ~ 1|MMS,
               #data=hedge_all)
               data=hedge_all)
summary.rma(mod0)

resmod0 <- mod_results(mod0,
                       group="MMS",
                       mod="Metrics",
                       at=list(Metrics=c("Median Grain","Silt Clay",
                                         "Zn","Pb","Ni","Cu","total Ba",
                                         "heavy metals","total hydrocarbons")),
                       data=hedge_all)

resmod0$mod_table

(p <- orchard_plot(resmod0,xlab="Hedge's g",
                   group = "MMS", mod = "Metrics",angle = 0, trunk.size = 1,branch.size = 2,alpha=0.2,k=F)+
    geom_hline(yintercept=0,size=1,linetype="dashed")+
    scale_fill_manual(values=c("grey","grey","grey","gray","gray","grey","gray","grey","black"))+
    scale_color_manual(values=c("gray","gray","gray","gray","gray","gray","gray","gray","gray"))+
    theme(legend.position="none")+
    theme(axis.text=element_text(family="sans",color="black"))+
    theme(axis.text.y=element_text(size=14),axis.text.x = element_text(size=12)))

###s2:Extract model estimates#####
s2_chemical <- data.frame(resmod0$mod_table)
s2_chemical$pval <- rev(mod0$pval) #order of metrics is opposite to pval
s2_chemical$scenario <- c("scenario 2")

#Combine s1,s2,s3 chemical model coefficients####
s1s2s3 <- rbind(s1s3,s2_chemical)
save(s1s2s3,file="D:/UoE/Writings/Data Chapter 2/LO/revisions/coding/s1s2s3chemical.Rdata")

s1s2s3 <- s1s2s3 %>%
  mutate(significance = case_when(
    pval < 0.001 ~ "***",
    pval < 0.01 ~ "**",
    pval < 0.05 ~ "*",
    TRUE ~ ""
  )) %>%
  mutate(name = gsub("Total hydrocarbons","Hydrocarbons",name),
         name = gsub("Heavy metals","Metals",name)) 

s1s2s3_hydrocarbonmetal <- s1s2s3 %>%
  filter(name %in% c("Total hydrocarbons","Heavy metals")) %>%
  mutate(name = gsub("Total hydrocarbons","Hydrocarbons",name),
         name = gsub("Heavy metals","Metals",name)) %>%
  mutate(name = factor(name,levels = c("Metals","Hydrocarbons")))

(p_chemical <- ggplot(s1s2s3_hydrocarbonmetal,aes(y=name,x=estimate,group=scenario))+
  geom_vline(xintercept=0,linetype="dashed")+
  geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
  geom_text(aes(label = significance,x=ifelse(estimate < 0,0.2*upperCL,lowerCL),
                hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
            size=6,color="black")+
  scale_y_discrete(labels = function(x) str_wrap(x, width = 10)) +
  facet_grid(~scenario,scales="free")+
  labs(x="Hedge's g")+
  theme_bw(base_size = 14)+
  theme(axis.title.y = element_blank(),
        axis.text = element_text(size=14,colour = "black"),
        strip.text = element_text(size = 16)))

(p_chemical <- ggplot(s1s2s3_hydrocarbonmetal,aes(y=name,x=estimate,group=scenario))+
  geom_vline(xintercept=0,linetype="dashed")+
  geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
  geom_text(aes(label = significance,x=ifelse(estimate < 0,0.2*upperCL,lowerCL),
                hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
            size=6,color="black")+
  scale_y_discrete(labels = function(x) str_wrap(x, width = 10)) +
  facet_grid(~scenario,scales="free")+
  labs(x="Hedge's g")+
  theme_bw(base_size = 14)+
  theme(axis.title.y = element_blank(),
        axis.text = element_text(size=14,colour = "black"),
        strip.text = element_text(size = 16)))

ggsave(p_chemical,path = "D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename = "s1s2s3chemical.png",,width=8,height=4,dpi=600,bg="white")


(p_chemical_all <- ggplot(s1s2s3,aes(y=name,x=estimate,group=scenario))+
    geom_vline(xintercept=0,linetype="dashed")+
    geom_pointrange(aes(xmin=lowerCL,xmax=upperCL),position=position_dodge2(width=0.5))+
    geom_text(aes(label = significance,x=ifelse(estimate < 0,0.2*upperCL,0.6*lowerCL),
                  hjust = ifelse(estimate > 0, -0.2,1.2)),position=position_dodge2(width=0.5),
              size=6,color="black")+
    scale_y_discrete(labels = function(x) str_wrap(x, width = 10)) +
    facet_grid(~scenario,scales="free")+
    labs(x="Hedge's g")+
    theme_bw(base_size = 14)+
    theme(axis.title.y = element_blank(),
          axis.text = element_text(size=14,colour = "black"),
          strip.text = element_text(size = 16)))

ggsave(p_chemical_all,path = "D:/UoE/Writings/Data Chapter 2/LO/revisions/coding",
       filename = "s1s2s3chemicalfull.png",,width=8,height=6,dpi=600,bg="white")
